using System;

class Program
{
    const int VELICINA_MAPE = 2100000; 
    enum POLJE
    {
        PRAZNO,
        HARI,
        DEMENTOR
    }
    static int[] mapa = new int[VELICINA_MAPE];
    static int brojDementoraKojiPostoje;
    static int harijevaPozicija;
    static int relativnaPozicijaNajblizegDementora = 0;

    enum POTEZ
    {
        POCETAK,
        MagijaSever,
        MagijaJug,
        PomeriKaSeveru
    }

    static POTEZ prethodniPotez = POTEZ.POCETAK;

    static bool zivIzdrav = true;

    static void Main(string[] args)
    {
        int N = int.Parse(Console.ReadLine());
        string[] ulaz = Console.ReadLine().Split();
        char[] listaPoteza = new char[2100000];
        int potezPoRedu = 0;

        mapa[VELICINA_MAPE / 2] = (int)POLJE.HARI;
        harijevaPozicija = VELICINA_MAPE / 2;
        brojDementoraKojiPostoje = N;

        for (int i = 0; i < N; i++)
        {
            int pozicijaDementora = int.Parse(ulaz[i]);

            mapa[VELICINA_MAPE / 2 + pozicijaDementora] = (int)POLJE.DEMENTOR;
        }

        while (zivIzdrav)
        {
            if (brojDementoraKojiPostoje == 0) { break; }
            if (mapa[harijevaPozicija] == (int)POLJE.DEMENTOR) { break; }
            if (potezPoRedu >= 1000000) { break; }

            POTEZ odabraniPotez = odaberiPotez();

            potezPoRedu++;

            switch(odabraniPotez)
            {
                case POTEZ.MagijaSever:
                    listaPoteza[potezPoRedu] = '1';
                    MagijaSever(); break;
                case POTEZ.MagijaJug:
                    listaPoteza[potezPoRedu] = '2';
                    MagijaJug(); break;
                case POTEZ.PomeriKaSeveru:
                    listaPoteza[potezPoRedu] = '3';
                    PomeriKaSeveru(); break;
            }

            PomeriDementore();
        }

        Console.WriteLine(N - brojDementoraKojiPostoje);
        
        foreach (char potez in listaPoteza)
        {
            Console.Write(potez);
        }
    }

    static POTEZ odaberiPotez()
    {
        POTEZ potez = POTEZ.PomeriKaSeveru;
        int udaljenostNajblizegDementora = UdaljenostNajblizegDementora();

        if (udaljenostNajblizegDementora > 0 && prethodniPotez != POTEZ.MagijaSever)
        {
            potez = POTEZ.MagijaSever;
        }
        else if (udaljenostNajblizegDementora < 0 && prethodniPotez != POTEZ.MagijaJug)
        {
            potez = POTEZ.MagijaJug;
        }
        else if (udaljenostNajblizegDementora < 0 && prethodniPotez != POTEZ.PomeriKaSeveru) // fali logika
        {
            potez = POTEZ.PomeriKaSeveru;
        }

        prethodniPotez = potez;

        return potez;
    }

    static int UdaljenostNajblizegDementora()
    {
        int relativnaPozicijaDementora = 1;
        bool nadjen = false;

        while (nadjen == false)
        {
            if (mapa[harijevaPozicija + relativnaPozicijaDementora] == (int)POLJE.DEMENTOR)
            {
                relativnaPozicijaNajblizegDementora = relativnaPozicijaDementora;
                return relativnaPozicijaDementora;
            }
            else if (mapa[harijevaPozicija - relativnaPozicijaDementora] == (int)POLJE.DEMENTOR)
            {
                relativnaPozicijaNajblizegDementora = -relativnaPozicijaDementora;
                return -relativnaPozicijaDementora;
            }
            else
            {
                relativnaPozicijaDementora++;
            }
        }

        return 0; // nece se desiti jer se svakako provera da li postoje dementori pre pozivanja funkcije
    }

    static void MagijaSever()
    {
        // znamo da je pozitivno jer se pozvala ova funkcija
        mapa[harijevaPozicija + relativnaPozicijaNajblizegDementora] = (int)POLJE.PRAZNO;
        brojDementoraKojiPostoje--;
    }

    static void MagijaJug()
    {
        mapa[harijevaPozicija - relativnaPozicijaNajblizegDementora] = (int)POLJE.PRAZNO;
        brojDementoraKojiPostoje--;
    }

    static void PomeriKaSeveru()
    {
        mapa[harijevaPozicija] = (int)POLJE.PRAZNO;
        harijevaPozicija++;
        mapa[harijevaPozicija] = (int)POLJE.HARI;
    }

    static void PomeriDementore()
    {
        for (int i = harijevaPozicija + 1; i < mapa.Length; i++)
        {
            if (mapa[i] == (int)POLJE.DEMENTOR)
            {
                mapa[i] = (int)POLJE.PRAZNO;
                mapa[i - 1] = (int)POLJE.DEMENTOR;
            }
        }

        for (int i = harijevaPozicija - 1; i > 0; i--)
        {
            if (mapa[i] == (int)POLJE.DEMENTOR)
            {
                mapa[i] = (int)POLJE.PRAZNO;
                mapa[i + 1] = (int)POLJE.DEMENTOR;
            }
        }
    }
}